<?php
/**
* Fuel Junior
* Version 5.0.0
**/

if (!defined('ABSPATH')) {
	exit();
}

if (!isset($content_width)) {
	$content_width = 1400;
}

/* DELETE fuel_wireframe_css filter when you start local development, leave on wireframe. */
add_filter('fuel_wireframe_css', '__return_true');

/* DELETE fuel_remote_uploads_url function when you are done with local development. */
function fuel_remote_uploads_url() {
	return 'https://example.fm1.dev/wp-content/uploads';
}
//add_filter( 'pre_option_upload_url_path', 'fuel_remote_uploads_url' );


/* Location/Map Section Filter to add content to Shortcode */
function fuel_locations_section(){
	$html = '<section class="contain locations-section">
		<h2 class="locations-title">Our Locations</h2>
		<div class="fm-map"></div>
	</section>';

	return apply_shortcodes($html);
}
add_filter('locations_section', 'fuel_locations_section');

/* Wide Contact Section Filter to add content to Shortcode */
function fuel_contact_section(){
	$html = '<div class="contain contact-section">
		<div class="contact-intro">
			<h2 class="contact-title">Contact Us</h2>
			<p class="contact-emergency">If you are experiencing a medical emergency, please call 911.</p>
			<p class="contact-statement">Please complete the form and our team will contact you during our regular business hours.</p>
		</div>
		<div class="contact-form">[gravityform id="1" title="false" description="false" ajax="true"]</div>
	</div>';

	return apply_shortcodes($html);
}
add_filter('contact_section', 'fuel_contact_section');


/* Use the [search] shortcode to place the search form anywhere, specifically in the menu */
function search_form() {
	return get_search_form(false);
}
add_shortcode('search', 'search_form');